#ifndef SYMMETRY_EXPERIMENTER_PLUGIN_H
#define SYMMETRY_EXPERIMENTER_PLUGIN_H

#include "ExperimenterPlugin.h"
#include "PerfQueue.h"
#include "Debug.h"

extern "C" _EXPORT ExperimenterPlugin *instantiate_exp();

/*******************************************************
* Created: 7/29/00, CGP
* Modified: 9/25/00, CGP
*	Started changes to bring up to date with current plugin API.
* Modified: 1/7/01, CGP
*	Changes for event driven experimenter & new API call names.
* Modified: 1/9/01, CGP
*	Changes for debug server
*******************************************************/

class SymmetryExperimenterPlugin : public ExperimenterPlugin {
   	public:
   		int PLUGIN_API_Version() {return EXPERIMENTER_API_VER;};
   		 
      	// Call constructor to set up the environment for running a new rat.
      	SymmetryExperimenterPlugin(PortMessage *expRatPort,
      		PortMessage *envExpPort, DatabaseMessage *dbMsg, UserEnvMessage *userEnvMsg,
      		DebugServer *bugServer);
       	~SymmetryExperimenterPlugin();
      	
      	// Redeclare & override virtual functions
      	void PLUGIN_Setup();
      	void PLUGIN_RunTrial();
      	void PLUGIN_RunStep();
      	void PLUGIN_RunCurrentRat();
      	void PLUGIN_RatConsumedFood();
      	void PLUGIN_RatMoved(BMessage *msg);  

	private:
		void AddPerformanceRecord(int trialType, int armNumber,
			int foundFood, int consumedFood);
		void SetupForTrial(int startArm, int goalArm, int otherArm);
		void GetTrialInformation(int *startArm, int *goalArm,
			int *otherArm, int *trialType);
		bool RunTrialProtocol(int startArm, int goalArm, int otherArm, int trialType);
		bool TrainCriterionSatisified();
		bool TestCriterionSatisified();
		bool RunNextTrial();
		
		int ratNo; // number of current rat
		int trialNumber;
		char *mode; // "Train" or "Test"
		PerfQueue perfQueue;
};

#endif